Appending is very different as compared to the creation of new files and writing data into the new files. In cases of appending, files already exist and we need to simply add text at the end of the file. This is similar to log files as they are constantly updated with the system.

Log files are the perfect example of appending text as applications iteratively keep appending log details into these files. Logging frameworks are not required for this problem, but you must know how to append text into existing files. In order to solve this problem, you must be aware of convenience classes to write character files.

The class has constructors that assume the acceptability of default byte-buffer and character encoding. If you wish to specify the values yourself, you can simply construct the OutputStreamWriter using the FileOutputStream. The availability of files depends on the underlying platforms, which determine if the file might be created or not.

A few platforms allow files to be initialised for writing functions using a single FileWrite or multiple file-writing objects. However, constructors from this class will be failing once the involved file is already initialised. FileWriter is used for writing character streams and FileOutputStream can write raw byte streams. The special constructor in  FileWriter accepts a file, once passed true the file can be opened in the append mode. This makes the task easier by enabling adding text at the end of the file. This FileWriter can be used to add text to a file multiple times. One of the benefits to add text using this method is that it maintains the position and length.
